/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.features;

import com.mojang.serialization.Codec;
import com.ordana.immersive_weathering.features.IcicleClusterFeatureConfig;
import com.ordana.immersive_weathering.features.IcicleHelper;
import com.ordana.immersive_weathering.reg.ModBlocks;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5721;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5861;

public class IcicleClusterFeature
extends class_3031<IcicleClusterFeatureConfig> {
    public IcicleClusterFeature(Codec<IcicleClusterFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<IcicleClusterFeatureConfig> context) {
        class_5281 structureWorldAccess = context.method_33652();
        class_2338 blockPos = context.method_33655();
        IcicleClusterFeatureConfig icicleClusterFeatureConfig = (IcicleClusterFeatureConfig)context.method_33656();
        class_5819 random = context.method_33654();
        if (!IcicleHelper.canGenerate((class_1936)structureWorldAccess, blockPos)) {
            return false;
        }
        int i = icicleClusterFeatureConfig.height.method_35008(random);
        float f = icicleClusterFeatureConfig.wetness.method_33920(random);
        float g = icicleClusterFeatureConfig.density.method_33920(random);
        int j = icicleClusterFeatureConfig.radius.method_35008(random);
        int k = icicleClusterFeatureConfig.radius.method_35008(random);
        for (int l = -j; l <= j; ++l) {
            for (int m = -k; m <= k; ++m) {
                double d = this.icicleChance(j, k, l, m, icicleClusterFeatureConfig);
                class_2338 blockPos2 = blockPos.method_10069(l, 0, m);
                this.generate(structureWorldAccess, random, blockPos2, l, m, f, d, i, g, icicleClusterFeatureConfig);
            }
        }
        return true;
    }

    private void generate(class_5281 world, class_5819 random, class_2338 pos, int localX, int localZ, float wetness, double icicleChance, int height, float density, IcicleClusterFeatureConfig config) {
        Optional optional = class_5721.method_32982((class_3746)world, (class_2338)pos, (int)config.floorToCeilingSearchRange, IcicleHelper::canGenerate, IcicleHelper::canReplaceOrLava);
        if (optional.isPresent()) {
            OptionalInt optionalInt = ((class_5721)optional.get()).method_32985();
            OptionalInt optionalInt2 = ((class_5721)optional.get()).method_32987();
            if (optionalInt.isPresent() || optionalInt2.isPresent()) {
                int t;
                int n;
                int m;
                int l;
                int k;
                int j;
                boolean bl2;
                class_5721 caveSurface;
                boolean bl;
                boolean bl3 = bl = random.method_43057() < wetness;
                if (bl && optionalInt2.isPresent() && this.canWaterSpawn(world, pos.method_33096(optionalInt2.getAsInt()))) {
                    int i = optionalInt2.getAsInt();
                    caveSurface = ((class_5721)optional.get()).method_32983(OptionalInt.of(i - 1));
                    world.method_8652(pos.method_33096(i), class_2246.field_10382.method_9564(), 2);
                } else {
                    caveSurface = (class_5721)optional.get();
                }
                OptionalInt i = caveSurface.method_32987();
                boolean bl4 = bl2 = random.method_43058() < icicleChance;
                if (optionalInt.isPresent() && bl2 && this.isLava((class_4538)world, pos.method_33096(optionalInt.getAsInt()))) {
                    j = config.icicleBlockLayerThickness.method_35008(random);
                    this.placeIceBlocks(world, pos.method_33096(optionalInt.getAsInt()), j, class_2350.field_11036);
                    k = i.isPresent() ? Math.min(height, optionalInt.getAsInt() - i.getAsInt()) : height;
                    l = this.getHeight(random, localX, localZ, density, k, config);
                } else {
                    l = 0;
                }
                int n2 = k = random.method_43058() < icicleChance ? 1 : 0;
                if (i.isPresent() && k != 0 && this.isLava((class_4538)world, pos.method_33096(i.getAsInt()))) {
                    m = config.icicleBlockLayerThickness.method_35008(random);
                    this.placeIceBlocks(world, pos.method_33096(i.getAsInt()), m, class_2350.field_11033);
                    j = optionalInt.isPresent() ? Math.max(0, l + class_3532.method_32751((class_5819)random, (int)(-config.maxStalagmiteStalactiteHeightDiff), (int)config.maxStalagmiteStalactiteHeightDiff)) : this.getHeight(random, localX, localZ, density, height, config);
                } else {
                    j = 0;
                }
                if (optionalInt.isPresent() && i.isPresent() && optionalInt.getAsInt() - l <= i.getAsInt() + j) {
                    n = i.getAsInt();
                    int o = optionalInt.getAsInt();
                    int p = Math.max(o - l, n + 1);
                    int q = Math.min(n + j, o - 1);
                    int r = class_3532.method_32751((class_5819)random, (int)p, (int)(q + 1));
                    int s = r - 1;
                    m = o - r;
                    t = s - n;
                } else {
                    m = l;
                    t = j;
                }
                int n3 = n = random.method_43056() && m > 0 && t > 0 && caveSurface.method_33385().isPresent() && m + t == caveSurface.method_33385().getAsInt() ? 1 : 0;
                if (optionalInt.isPresent()) {
                    IcicleHelper.generateIcicle((class_1936)world, pos.method_33096(optionalInt.getAsInt() - 1), class_2350.field_11033, m, n != 0);
                }
                if (i.isPresent()) {
                    IcicleHelper.generateIcicle((class_1936)world, pos.method_33096(i.getAsInt() + 1), class_2350.field_11036, t, n != 0);
                }
            }
        }
    }

    private boolean isLava(class_4538 world, class_2338 pos) {
        return !world.method_8320(pos).method_27852(class_2246.field_10164);
    }

    private int getHeight(class_5819 random, int localX, int localZ, float density, int height, IcicleClusterFeatureConfig config) {
        if (random.method_43057() > density) {
            return 0;
        }
        int i = Math.abs(localX) + Math.abs(localZ);
        float f = (float)class_3532.method_32854((double)i, (double)0.0, (double)config.maxDistanceFromCenterAffectingHeightBias, (double)((double)height / 2.0), (double)0.0);
        return (int)IcicleClusterFeature.clampedGaussian(random, height, f, config.heightDeviation);
    }

    private boolean canWaterSpawn(class_5281 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        if (!(blockState.method_27852(class_2246.field_10382) || blockState.method_27852(class_2246.field_10295) || blockState.method_27852(ModBlocks.ICICLE.get()))) {
            class_2350 direction;
            Iterator var4 = class_2350.class_2353.field_11062.iterator();
            do {
                if (var4.hasNext()) continue;
                return this.isStoneOrWater((class_1936)world, pos.method_10074());
            } while (this.isStoneOrWater((class_1936)world, pos.method_10093(direction = (class_2350)var4.next())));
        }
        return false;
    }

    private boolean isStoneOrWater(class_1936 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26164(class_3481.field_25806) || blockState.method_26227().method_15767(class_3486.field_15517);
    }

    private void placeIceBlocks(class_5281 world, class_2338 pos, int height, class_2350 direction) {
        class_2338.class_2339 mutable = pos.method_25503();
        for (int i = 0; i < height; ++i) {
            if (!IcicleHelper.generateIceBlock((class_1936)world, (class_2338)mutable)) {
                return;
            }
            mutable.method_10098(direction);
        }
    }

    private double icicleChance(int radiusX, int radiusZ, int localX, int localZ, IcicleClusterFeatureConfig config) {
        int i = radiusX - Math.abs(localX);
        int j = radiusZ - Math.abs(localZ);
        int k = Math.min(i, j);
        return class_3532.method_37958((float)k, (float)0.0f, (float)config.maxDistanceFromCenterAffectingChanceOfIcicleColumn, (float)config.chanceOfIcicleColumnAtMaxDistanceFromCenter, (float)1.0f);
    }

    private static float clampedGaussian(class_5819 random, float max, float mean, float deviation) {
        return class_5861.method_33903((class_5819)random, (float)mean, (float)deviation, (float)0.0f, (float)max);
    }
}

